(defun c:mbase()
   (setq basetype (getstring "\nPlease select base type on screen:"))
   (setq bname (getstring "\nPlease select base size on screen:"))
   (cond
      ((= basetype "A") (setq bname1 "A"))
      ((= basetype "B") (setq bname1 "A"))
      ((= basetype "C") (setq bname1 "A"))
      ((= basetype "D") (setq bname1 "A"))
      (t (setq bname1 "B"))
   )
   (setq basename (strcat "*/acad-r10/basdwg/" bname1 bname))
   (setq mplate (atoi bname))
   (setq A (getreal "\nPlease select A value on screen:"))
   (setq B (getreal "\nPlease select B&C value on screen:"))
   (setq C (getreal))
   (setq Pbase (list 0 0))
   (command "insert" basename Pbase "1" "0")
   (command "zoom" "a")
   (setq M0 (getvar "extmin"))
   (setq M1 (getvar "extmax"))
   (command "move" "c" M0 M1 "" M0 (list 50. 100.))
   (setq pbase (list (+ 50 (abs (car M0)))  (+ 100 (abs (cadr M0)))))
   (setq x (car Pbase) y (cadr Pbase))
   (command "zoom" "all")
   (command "zoom" "0.8x")
   (cond
      ((< mplate 2323) (setq Mthick 30))
      ((< mplate 2730) (setq Mthick 35))
      ((< mplate 3030) (setq Mthick 40))
      ((< mplate 4040) (setq Mthick 45))
      ((< mplate 4545) (setq Mthick 50))
      (t (setq Mthick 60))
   )
   (setq bl (* (fix (/ mplate 100)) 10))
   (setq bw (* (- mplate (* bl 10)) 10))
   (cond
      ((or (= mplate 3335) (= mplate 3340)) (setq bl (+ bl 70)))
      ((or (< mplate 3335) (and (> mplate 3340) (< mplate 4545)))
                                             (setq bl (+ bl 50)))
      (t (setq bl (+ bl 100)))
   )
   (cond
      ((< mplate 2020) (setq Mm 15))
      ((< mplate 2525) (setq Mm 20))
      ((< mplate 3030) (setq Mm 25))
      ((< mplate 3535) (setq Mm 30))
      ((< mplate 4545) (setq Mm 35))
      (t (setq Mm 40))
   )
   (setq Pc (list (- x (/ bl 1.9)) (- (cadr Pbase) 35)))
   (setq Pb (list (- x (/ bl 1.9)) (+ (cadr Pbase) 12 Mthick)))
   (setq Pa (list (- x (/ bl 1.9)) (+ (cadr Pbase) 45 Mthick)))
   (setq Paa (list (- x (/ bl 1.9)) (+ (cadr Pbase) 48 Mm Mthick)))
   (setq Pa0 (getvar "extmax"))
   (if (= basetype "B")
      (progn
         (command "stretch" "c" Pa Pa0 "" '(0 0) (list 0 Mm))
         (setq s1 (ssget "w" (list (+ x (/ bl 1.9)) (+ (cadr Pbase) 30 Mthick))
                  (list (+ x (/ bl -1.9)) (+ (cadr Pbase) Mthick 43))))
         (command "copy" s1 "" '(0 0) (list 0 Mm))
         (setq Pa (list (- x (/ bl 1.9)) (+ (cadr Pbase) 42 Mm Mthick)))
      )
   )
   (if (= basetype "C")
      (progn
         (command "erase" "w" (list (+ x (/ bl 1.9)) (- (cadr Pbase) 3))
                              (list (+ x (/ bl -1.9)) (+ (cadr Pbase) 5)) "")
         (command "stretch" "c" (list (+ x (/ bl 1.9)) (+ (cadr Pbase) 15))
                          (list (+ x (/ bl -1.9)) (+ (cadr Pbase) 15 Mthick))
                  "" (list 0 Mthick) '(0 0))
         (setq B (- B Mthick))
      )
   )
   (if (= basetype "D")
      (progn
         (command "stretch" "c" Pa Pa0 "" '(0 0) (list 0 Mm))
         (setq s1 (ssget "w" (list (+ x (/ bl 1.9)) (+ (cadr Pbase) 30 Mthick))
                  (list (+ x (/ bl -1.9)) (+ (cadr Pbase) Mthick 43))))
         (command "copy" s1 "" '(0 0) (list 0 Mm))
         (command "erase" "w" (list (+ x (/ bl 1.9)) (- (cadr Pbase) 3))
                              (list (+ x (/ bl -1.9)) (+ (cadr Pbase) 5)) "")
         (command "stretch" "c" (list (+ x (/ bl 1.9)) (+ (cadr Pbase) 15))
                          (list (+ x (/ bl -1.9)) (+ (cadr Pbase) 15 Mthick))
                  "" (list 0 Mthick) '(0 0))
         (setq B (- B Mthick))
         (setq Pa (list (- x (/ bl 1.9)) (+ (cadr Pbase) 42 Mm Mthick)))
      )
   )
   (setq Pa0 (getvar "extmax"))
   (setq Pb0 (list (car pa0) (+ A Mm (cadr pa0))))
   (setq Pc0 (list (car pb0) (+ B Mm (cadr pb0))))
   (command "stretch" "c" Pa Pa0 "" '(0 0) (list 0 (- A 35)))
   (command "stretch" "c" Pb Pb0 "" '(0 0) (list 0 (- B 35)))
   (command "stretch" "c" Pc Pc0 "" '(0 0) (list 0 (- C 100)))
   (setvar "limmin" '(0 0))
   (setvar "limmax" Pa0)
   (command "zoom" "a")
   (menucmd "S=S")
)
